<?php
require_once '../config.php';
session_start();
if (empty($_SESSION['is_admin'])) {
    header("Location: ../login.php"); exit;
}

// Add Task
if (isset($_POST['add_task'])) {
    $stmt = $pdo->prepare("INSERT INTO tasks (title, description, reward, link) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['title'], $_POST['desc'], $_POST['reward'], $_POST['link']]);
}

// Delete Task
if (isset($_GET['delete'])) {
    $pdo->prepare("DELETE FROM tasks WHERE id = ?")->execute([$_GET['delete']]);
}

$tasks = $pdo->query("SELECT * FROM tasks ORDER BY id")->fetchAll();
?>
<!DOCTYPE html>
<html><head><title>Admin - Tasks</title><style>
    body{font-family:Arial;background:#f4f4f4;padding:2rem;}
    .box{background:#fff;padding:2rem;border-radius:16px;box-shadow:0 0 15px rgba(0,0,0,.1);max-width:900px;margin:auto;}
    input, textarea, button{padding:10px;margin:5px 0;width:100%;border:1px solid #ddd;border-radius:8px;}
    button{background:#28a745;color:#fff;border:none;cursor:pointer;}
    table{width:100%;border-collapse:collapse;margin-top:1rem;}
    th,td{border:1px solid #ddd;padding:10px;text-align:left;}
    th{background:#28a745;color:white;}
    .delete{color:#dc3545;}
</style></head><body>
<div class="box">
    <h2>Add New Task</h2>
    <form method="post">
        <input name="title" placeholder="Title" required>
        <textarea name="desc" placeholder="Description" required></textarea>
        <input name="reward" type="number" step="0.01" placeholder="Reward (e.g. 250)" required>
        <input name="link" placeholder="Task Link" required>
        <button name="add_task">Add Task</button>
    </form>

    <h2>All Tasks</h2>
    <table>
        <tr><th>Title</th><th>Reward</th><th>Link</th><th>Action</th></tr>
        <?php foreach ($tasks as $t): ?>
        <tr>
            <td><?= htmlspecialchars($t['title']) ?></td>
            <td>₦<?= $t['reward'] ?></td>
            <td><a href="<?= $t['link'] ?>" target="_blank">Link</a></td>
            <td><a href="?delete=<?= $t['id'] ?>" class="delete" onclick="return confirm('Delete?')">Delete</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body></html>