<?php
session_start();
require_once '../config.php';
if (empty($_SESSION['is_admin'])) {
    header("Location: login.php"); exit;
}

// ========================================
// 1. Total Users
// ========================================
$totalUsers = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

// ========================================
// 2. Total Balance (All 4 types)
// ========================================
$balances = $pdo->query("
    SELECT 
        COALESCE(SUM(subventions),0) AS sub,
        COALESCE(SUM(team_rewards),0) AS team,
        COALESCE(SUM(daily_cashback),0) AS cashback,
        COALESCE(SUM(wallet_balance),0) AS wallet
    FROM user_wallets
")->fetch();

$totalBalance = $balances['sub'] + $balances['team'] + $balances['cashback'] + $balances['wallet'];

// ========================================
// 3. Pending Tasks
// ========================================
$pendingTasks = $pdo->query("SELECT COUNT(*) FROM user_tasks WHERE status = 'pending'")->fetchColumn();

// ========================================
// 4. Pending Withdrawals
// ========================================
$pendingWithdrawals = $pdo->query("SELECT COUNT(*) FROM withdrawals WHERE status = 'pending'")->fetchColumn();

// ========================================
// 5. Total Funding (Successful Deposits)
// ========================================
$totalFunding = $pdo->query("SELECT COALESCE(SUM(amount),0) FROM funding WHERE status = 'success'")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Ninja Hope</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --green: #28a745; --gray: #f5f5f5; --shadow: 0 4px 12px rgba(0,0,0,.08); }
        * { margin:0; padding:0; box-sizing:border-box; }
        body { font-family: 'Segoe UI', sans-serif; background: var(--gray); padding: 1rem; }
        .header { background: var(--green); color: white; padding: 1rem; text-align: center; border-radius: 16px; margin-bottom: 1rem; }
        .header h1 { font-size: 1.4rem; }
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 1rem; margin-bottom: 1.5rem; }
        .stat-card { background: white; padding: 1.5rem; border-radius: 16px; text-align: center; box-shadow: var(--shadow); }
        .stat-value { font-size: 1.8rem; font-weight: 700; color: var(--green); }
        .stat-label { color: #666; font-size: 0.95rem; margin-top: 0.5rem; }
        .menu { display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 1rem; }
        .menu-btn { background: white; padding: 1.2rem; border-radius: 16px; text-align: center; text-decoration: none; color: #333; box-shadow: var(--shadow); font-weight: 500; }
        .menu-btn i { display: block; font-size: 1.6rem; margin-bottom: 0.5rem; color: var(--green); }
        .logout { display: block; text-align: center; margin-top: 2rem; color: #dc3545; text-decoration: none; font-weight: 500; }
    </style>
</head>
<body>

    <div class="header">
        <h1>Admin Dashboard</h1>
        <p>Welcome, Admin | <?= date('F j, Y g:i A') ?></p>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-value"><?= number_format($totalUsers) ?></div>
            <div class="stat-label">Total Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">₦<?= number_format($totalBalance, 2) ?></div>
            <div class="stat-label">Total Balance</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $pendingTasks ?></div>
            <div class="stat-label">Pending Tasks</div>
        </div>
        <div class="stat-card">
            <div class="stat-value"><?= $pendingWithdrawals ?></div>
            <div class="stat-label">Pending Withdrawals</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">₦<?= number_format($totalFunding, 2) ?></div>
            <div class="stat-label">Total Funding</div>
        </div>
    </div>

    <div class="menu">
        <a href="tasks.php" class="menu-btn"><i class="fas fa-tasks"></i> Manage Tasks</a>
        <a href="pending_tasks.php" class="menu-btn"><i class="fas fa-clock"></i> Pending Tasks</a>
        <a href="balances.php" class="menu-btn"><i class="fas fa-wallet"></i> Adjust Balances</a>
        <a href="withdrawals.php" class="menu-btn"><i class="fas fa-money-check-alt"></i> Withdrawals</a>
        <a href="funding.php" class="menu-btn"><i class="fas fa-credit-card"></i> Funding</a>
        <a href="users.php" class="menu-btn"><i class="fas fa-users"></i> All Users</a>
    </div>

    <a href="logout.php" class="logout">Logout</a>

</body>
</html>